#!/bin/sh

fw_set_software=4.6.0.101
fw_set_module=02.36.00.00


LEDCNT=$(cat /proc/sysinfo/pd/led  | wc -l)
MAX_LED_IDX=$(expr $LEDCNT - 1)

led_all_red()
{
    for i in $(seq 0 $MAX_LED_IDX); do
        echo "FAST RED" > /tmp/status/led-manager/led$i
    done
    sleep 1
}


led_start_sys()                                                                         
{                                                                                     
    echo "FAST RED" > /tmp/status/led-manager/led4
    sleep 1                                                                           
} 

led_start_wan()                                        
{                                                      
    echo "FAST RED" > /tmp/status/led-manager/led0    
    sleep 1                                            
}


ledstop()
{
    for i in $(seq 0 $MAX_LED_IDX); do
        rm -f /tmp/status/led-manager/led$i
    done
    sleep 1
}

get_software_fw_info ()
{
    # getting netmodule firmware
    fw_get_software=$(nbinfo | head -n1 | cut -d " " -f2)
    # echo "DEBUG: Result is $fw_get_software"
}

get_module_fw_info ()
{
    # getting the module firmware
    timeout=0
    while true;
    do
      fw_get_module=$(wwan-cmd 0 'AT!IMPREF?' | grep 'current fw version: ' | awk -F ':' '{ print $2; }' | sed 's/ //g' | sed 's/\r//g')
      if [ -n "$fw_get_module" ]; then
        echo "DEBUG: Result is $fw_get_module"
        break
      elif [ $timeout -gt 120 ]
      then
        echo "DEBUG: Killing"
        break
      else
        echo "DEBUG: Waiting for module boot"
      timeout=$(( $timeout + 1 ))
      sleep 1
      fi
    done
}

get_module_fw_info                                                                  
echo "DEBUG: $fw_get_module current firmware"                                       
echo "DEBUG: $fw_set_module required firmware" 

if [ "$fw_set_module" = "$fw_get_module" ]; then                                  
        echo "DEBUG: Correct Version Installed"                                       
 else                                                                                 
        echo "DEBUG: Upgrading system firmware"                                       
        ledstop;                                                                      
        led_start_wan;
        sleep 10;
        cli update firmware WWAN1 file:///mnt/media/autorun/image/firmware_mc7430.tar.gz
        ledstop;
                                                                    
fi

get_software_fw_info
echo "DEBUG: $fw_get_software current firmware"
echo "DEBUG: $fw_set_software required firmware"

if [ "$fw_set_software" = "$fw_get_software" ]; then 
        echo "DEBUG: Correct Version Installed"
 else
        echo "DEBUG: Upgrading system firmware"
	ledstop;  
	led_start_sys;
        sleep 10;
        cli update -r software file:///mnt/media/autorun/image/firmware_nb2700.img
	ledstop;
fi


wwan-cmd 0 'AT!IMPREF?' | grep 'current fw version: ' | awk -F ':' '{ print $2; }' | sed 's/ //g' | sed 's/\r//g'