#!/bin/sh

if [ "x$MNTPATH" = "x" ]; then
    echo "Mannualy set the mount path to $MNTPATH"
    MNTPATH="/mnt/media/autorun"
fi

/bin/sh -c "dos2unix $MNTPATH/auto*"
/bin/sh -c "dos2unix $MNTPATH/config/*"

. /$MNTPATH/autorun.conf
. /$MNTPATH/scripts/system_led
. /$MNTPATH/scripts/system_log
. /$MNTPATH/scripts/system_firmware
. /$MNTPATH/scripts/module_firmware
. /$MNTPATH/scripts/module_qmi

set_led_start

get_system_firmware
REBOOT=""
if [ "$SYSTEM_FW_ACTIVE" != "$SYSTEM_FIRMWARE" ]; then
    REBOOT="YES"
    log "upgrading system firmware to $SYSTEM_FIRMWARE ($SYSTEM_FW_ACTIVE)"
    cli update software "$STORAGE/$SYSTEM_FILENAME"
#    exit 0
fi

get_module_firmware
if [ "$MODULE_FW_ACTIVE" != "$MODULE_FIRMWARE" ]; then
    log "upgrading $MODEM firmware to $MODULE_FIRMWARE ($MODULE_FW_ACTIVE)"
    update_module_firmware    
#    exit 0
fi

get_module_firmware
if [ "$MODULE_CONF_ACTIVE" != "$MODULE_CONFIG" ]; then
    log "upgrading $MODEM config to $MODULE_CONFIG ($MODULE_CONF_ACTIVE)"
    update_module_firmware
#    exit 0
fi
led_mobile_green_solid

# signal success
ledsucc

if [ "$REBOOT" == "YES" ]; then
    set_led_reboot
    cli reboot
fi

ledstop
